<?php
App::uses('AppController', 'Controller');

class PagesController extends AppController
{
    public $helpers = array('MightyShortcodes');

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('view', 'home');

        if (in_array($this->request->action, array('admin_add', 'admin_edit', 'admin_delete'))) {
            if ($this->request->is(array('post', 'put'))) {
                if ($this->Auth->user('account_type') == 'Demo') {
                    $this->Flash->set(__('This request is disabled into demo.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->referer());
                }
            }
        }
    }

    public function isAuthorized($user = null)
    {
        return parent::isAuthorized($user);
    }

    public function home()
    {
        $this->layout = 'frontend';
        $this->loadModel('Link');

        $totalLinks = $this->Link->find('count');

        $totalHits = $this->Link->Stat->find('count');

        $totalUsers = $this->Link->User->find('count');

        $this->set('totalLinks', $totalLinks);
        $this->set('totalHits', $totalHits);
        $this->set('totalUsers', $totalUsers);
    }

    public function admin_index()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Manage All Pages');

        $this->paginate = array(
            //'conditions' => array('Bundle.user_id' => $this->Auth->user('id')),
            //'fields' => array('Bundle.id', 'Bundle.user_id' , 'Bundle.user_bundle_id', 'Bundle.name', 'Bundle.private', 'Bundle.views', 'Bundle.created', 'Bundle.updated', 'User.id', 'User.username'),
            'limit' => 10,
            'order' => array(
                'Page.created' => 'desc'
            )
        );
        $pages = $this->paginate('Page');

        $this->set('pages', $pages);
    }

    public function admin_add()
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Add New Page');

        if ($this->request->is('post')) {
            if (isset($this->request->data['Page']['slug']) && !empty($this->request->data['Page']['slug'])) {
                $this->request->data['Page']['slug'] = $this->Page->create_slug($this->request->data['Page']['slug']);
            } else {
                $this->request->data['Page']['slug'] = $this->Page->create_slug($this->request->data['Page']['title']);
            }

            $this->Page->create();
            if ($this->Page->save($this->request->data)) {
                $this->Flash->set(__('Your page has been saved.'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            }
            $this->Flash->set(__('Unable to add your post.'), array(
                'element' => 'error'
            ));
        }
    }

    public function admin_edit($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Edit Page');

        if (!$id) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page = $this->Page->findById($id);

        if (!$page) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        if ($this->request->is(array('post', 'put'))) {
            if (isset($this->request->data['Page']['slug']) && !empty($this->request->data['Page']['slug'])) {
                $this->request->data['Page']['slug'] = $this->Page->create_slug($this->request->data['Page']['slug'], $id);
            } else {
                $this->request->data['Page']['slug'] = $this->Page->create_slug($this->request->data['Page']['title'], $id);
            }

            $this->Page->id = $id;
            if ($this->Page->save($this->request->data)) {
                $this->Flash->set(__('Page has been updated'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            } else {
                //debug($this->User->validationErrors);
                $this->Flash->set(__('Page could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        } else {
            $this->request->data = $page;
            //unset($this->request->data['Page']['slug']);
        }
    }

    public function admin_delete($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Delete Page');

        if (!$id) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $page = $this->Page->findById($id);

        if (!$page) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $this->Page->id = $id;

        if ($this->Page->delete()) {
            $this->Flash->set(__('Page has been deleted'), array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'index'));
        } else {
            $this->Flash->set(__('Page was not deleted'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function view($slug = null)
    {
        $this->layout = 'frontend';

        if (!$slug) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page = $this->Page->findBySlug($slug);

        if (!$page) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $this->set('page', $page);

        $this->set('website_title', $page['Page']['title']);
    }
}
